/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.factories;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import com.badlogic.gdx.math.GridPoint2;
import com.badlogic.gdx.math.RandomXS128;
import com.badlogic.gdx.math.Vector2;
import com.google.inject.Inject;
import java.util.Random;
import technology.rocketjump.undermount.assets.entities.model.EntityAssetOrientation;
import technology.rocketjump.undermount.entities.EntityAssetUpdater;
import technology.rocketjump.undermount.entities.behaviour.ItemBehaviour;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.EntityType;
import technology.rocketjump.undermount.entities.model.physical.LocationComponent;
import technology.rocketjump.undermount.entities.model.physical.PhysicalEntityComponent;
import technology.rocketjump.undermount.entities.model.physical.item.ItemEntityAttributes;
import technology.rocketjump.undermount.mapping.model.TiledMap;

public class ItemEntityFactory {
    private static final float MAX_POSITION_OFFSET = 0.05f;
    private static final float ITEM_RADIUS = 0.4f;
    private final MessageDispatcher messageDispatcher;
    private final EntityAssetUpdater entityAssetUpdater;

    @Inject
    public ItemEntityFactory(MessageDispatcher messageDispatcher, EntityAssetUpdater entityAssetUpdater) {
        this.messageDispatcher = messageDispatcher;
        this.entityAssetUpdater = entityAssetUpdater;
    }

    public Entity create(ItemEntityAttributes attributes, GridPoint2 tilePosition, TiledMap areaMap) {
        PhysicalEntityComponent physicalComponent = this.createPhysicalComponent(attributes);
        ItemBehaviour behaviorComponent = new ItemBehaviour();
        LocationComponent locationComponent = this.createLocationComponent(attributes, tilePosition);
        Entity entity = new Entity(EntityType.ITEM, physicalComponent, behaviorComponent, locationComponent, this.messageDispatcher, areaMap);
        this.entityAssetUpdater.updateEntityAssets(entity);
        return entity;
    }

    private LocationComponent createLocationComponent(ItemEntityAttributes attributes, GridPoint2 tilePosition) {
        RandomXS128 random = new RandomXS128(attributes.getSeed());
        LocationComponent locationComponent = new LocationComponent();
        if (tilePosition != null) {
            Vector2 worldPosition = new Vector2((float)tilePosition.x + 0.5f, (float)tilePosition.y + 0.5f);
            worldPosition.x += ((Random)random).nextFloat() * 0.05f * 2.0f - 0.05f;
            worldPosition.y += ((Random)random).nextFloat() * 0.05f * 2.0f - 0.05f;
            locationComponent.setWorldPosition(worldPosition, false);
        }
        locationComponent.setFacing(EntityAssetOrientation.DOWN.toVector2().cpy());
        locationComponent.setRadius(0.4f);
        return locationComponent;
    }

    private PhysicalEntityComponent createPhysicalComponent(ItemEntityAttributes attributes) {
        PhysicalEntityComponent physicalComponent = new PhysicalEntityComponent();
        physicalComponent.setAttributes(attributes);
        return physicalComponent;
    }
}

